﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using GE.Physics;
using GE.Manager;
using Microsoft.Xna.Framework;

namespace GE.World.Entities
{
    class SnapperEntity:EnemyEntity
    {
        /// <summary>
        /// Snapper animation
        /// </summary>
        int _iIdAnimation;

        /// <summary>
        /// Current frame in the animation
        /// </summary>
        int _iAnimationCurretFrame;

        /// <summary>
        /// Current elapsed time in the animation
        /// </summary>
        int _iAnimationCurrentTime;

        /// <summary>
        /// Hit box
        /// </summary>
        //DynamicShapeRectangle _shape;

        /// <summary>
        /// Target to hit
        /// </summary>
        Vector2 _v2Target;

        /// <summary>
        /// The highest point to reach
        /// </summary>
        Vector2 _v2HighestPoint;

        /// <summary>
        /// Entity's birth time
        /// </summary>
        int _iBirthTime;

        /// <summary>
        /// Entity lifetime
        /// </summary>
        const int LIFETIME = 250;

        /// <summary>
        /// The current waypoint used by the enemy
        /// </summary>
        int _iCurrentWaypoint;

        /// <summary>
        /// List of waypoint
        /// </summary>
        Vector2[] _v2Waypoint;

        /// <summary>
        /// Animation the explosion
        /// </summary>
        int _iIdAnimationExplosion;

        /// <summary>
        /// Offset to display the explosion animation
        /// </summary>
        Vector2 _v2OffsetAnimationExplosion = new Vector2(15, 0);
#if !GAME
        public static string EDITOR_TILESET { get { return "enemysheet.xml";}}
        public static string EDITOR_SPRITE { get { return "snapper_2"; } }
#endif

        public Vector2 Target { set { _v2Target = value; } }

        public void setPosition(Vector2 v)
        {
            _v2Position = v;
            _shape._v2position = v;
        }

        public SnapperEntity()
            : base()
        {
            _iIdAnimation = -1;
            _iAnimationCurretFrame = -1;
            _iAnimationCurrentTime = -1;
            _shape = Physics.Physics.Instance.createDynamicRectangle(0, 0, Vector2.Zero, this);
            _shape._iGroup = (int)ePhysicGroup.ePhysicEnemy;
            _v2Waypoint = new Vector2[3];
        }

        public override void init()
        {
            _iIdAnimation = Visu.Instance.getAnimationID("Snapper");
            _iIdAnimationExplosion = Visu.Instance.getAnimationID("Little_Explosion");

            Animation snapperAnimation = Visu.Instance.getAnimation(_iIdAnimation);
            int idTexture = snapperAnimation.indexTexture;
            int idSprite = snapperAnimation.idFirstSprite;
            int iWidth = Visu.Instance.getSpriteWidth(idTexture, idSprite);
            int iHeight = Visu.Instance.getSpriteHeight(idTexture, idSprite);
            _shape.resize(iWidth, iHeight);
            base.init();
        }

        public override void activate()
        {
            _shape._bCollisionEnable = true;
            _iAnimationCurretFrame = -1;
            _iAnimationCurrentTime = -1;

            _v2HighestPoint = new Vector2((Position.X + _v2Target.X) * 0.5f, Position.Y - 50);
            _iCurrentWaypoint = 0;

            _v2Waypoint[0] = _v2Position;
            _v2Waypoint[1] = _v2HighestPoint;
            _v2Waypoint[2] = _v2Target;

            _iBirthTime = TimeClock.Clock.instance.millisecs;
            base.activate();
        }

        public override void update()
        {
            float fElapsedTime = TimeClock.Clock.instance.millisecs - _iBirthTime;
            float fRatio = fElapsedTime / LIFETIME;

            if (fRatio >= 1)
            {
                fRatio = 0;
                _iCurrentWaypoint++;
                _iBirthTime = TimeClock.Clock.instance.millisecs;
                if (_iCurrentWaypoint > 1)
                {
                    die();
                    return;
                }
            }

            Vector2 newPosition = Vector2.Zero;
            switch (_iCurrentWaypoint)
            {
                case 0:
                    newPosition = Vector2.CatmullRom(_v2Waypoint[0], _v2Waypoint[0], _v2Waypoint[1], _v2Waypoint[2], fRatio);
                    break;

                case 1:
                    newPosition = Vector2.CatmullRom(_v2Waypoint[0], _v2Waypoint[1], _v2Waypoint[2], _v2Waypoint[2], fRatio);
                    break;
            }
            setPosition(newPosition);

            //check collision
            CollisionResult res = Physics.Physics.Instance.checkFirstRegisteredCollisionEx(_shape, (int)ePhysicGroup.ePhysicPlayer);
            if (res != null)
            {
                res.Entity.hurt(_iDamages);
                die();
            }
        }

        public override void render()
        {
            Visu.Instance.displayAnimation(_iIdAnimation, ScreenPosition, ref _iAnimationCurretFrame, ref _iAnimationCurrentTime);
        }

        public override void die()
        {
            _bActive = false;
            _shape._bCollisionEnable = false;
            Manager.ExplosionManager.Instance.activate(_iIdAnimationExplosion, Position+_v2OffsetAnimationExplosion);
        }
    }
}
